// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%%%%%%% Author (s): Lerato Mohapi, and Dr. Simon Winberg %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%%%%%%% Institute: University of Cape Town %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%%%%%%% Course: EEE4084F - Digital Systems %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%%% Prac. Title: Simulating Planet X With Vogel Spiral Model Star Formation %%%%%%%%%%%%%%%%%%%%%%%%%
// %%%%%% Skills Required: OpenGL and OpenMP %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%% Ref: http://www.dcs.gla.ac.uk/~jhw/spirals/index.html?utm_source=twitterfeed&utm_medium=twitter %%
// %%%% Ref: http://condor.cc.ku.edu/~grobe/docs/intro-MPI-C.shtml %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%%%% Ref: http://wiki.ccs.tulane.edu/index.php5/Parallel_Loop_MPI %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <omp.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <sstream>

#define PI (3.141592653589793)
#define NUM_CORES 4

using namespace std;

//Declare Lights Variables for 3D Visualization
const GLfloat light_ambient[]  = { 0.0f, 0.0f, 0.0f, 1.0f };
const GLfloat light_diffuse[]  = { 1.0f, 1.0f, 1.0f, 1.0f };
const GLfloat light_specular[] = { 1.0f, 1.0f, 1.0f, 1.0f };
const GLfloat light_position[] = { 2.0f, 5.0f, 5.0f, 0.0f };
 
const GLfloat mat_ambient[]    = { 0.7f, 0.7f, 0.7f, 1.0f };
const GLfloat mat_diffuse[]    = { 0.8f, 0.8f, 0.8f, 1.0f };
const GLfloat mat_specular[]   = { 1.0f, 1.0f, 1.0f, 1.0f };
const GLfloat high_shininess[] = { 100.0f };

//Rotating Position
static int planet_pos=0;
 
static void resize(int width, int height) // Resize function for Display
{
    const float ar = (float) width / (float) height;
 
    glViewport(0, 0, width, height); // set frame area on the display screen for viewing the planet, play arount with this to set different views
    glMatrixMode(GL_PROJECTION); //specify which matrix is the current matrix
    glLoadIdentity();
    glFrustum(-ar, ar, -1.0, 1.0, 2.0, 100.0);
 
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity() ;
}
 
static void display(void) // Main Rendering Function: TODO:Implement the Serial Version of this
{
    	double stop, start = omp_get_wtime(); // Record Start time for this function
    	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    	glColor3d(0.1,0.1, 1.0); //Blue Color
 
    	glPushMatrix(); //Drawing the Main Planet and its Moon
        	glTranslated(0.0,0.0,-6.0); // Position on the Grid
		glRotatef ((GLfloat) planet_pos, 0.0, 1.0, 0.0); // Rotation
        	glutSolidSphere(0.5,50,50); // Planet X is a solid sphere of radious 0.5
    
    		glColor3d(1.0, 0.1, 0.1); // Its Moon colour is Red
    	
    		glTranslated(0.0,-0.25,-2); // Its Moon is at this position
		glRotatef((GLfloat) planet_pos, 0.0, 1.0, 0.0);// With Revolution around the Planet X
    		glutSolidSphere(0.3,16,16); // This moon is also a solid Sphere
    	glPopMatrix();

	//TODO: Thousands of Visible Stars forming a Vogel Spiral Model as seen from Planet X
	//TODO: Start with 1000 stars and observe th time it takes to render these stars as you increase their number 
    	int num_stars = 1000000; 		// Define Number of Stars (i.e. This varies as follows: 1000, 10000, 100000, and 1000000)

	// Vogel Spiral Algorithm Parameters
	int i=0,r=0, j; 				// The parameters r and i of the Vogel Spiral algorithm
    	double phi = (1 + sqrt(5)) / 2.0; 	// The golden ratio for Vogel Spiral
    	double theta=0, x, y;				// Theta parameter for Vogel Spiral Algorithm
	glColor3d(0.95,0.9,1.0);

	//TODO: Implement the Vogel Spiral Model for Planet X Star formation
	//TODO: Given a Vogel Spiral Model Psuedo Code in the prac.3 instructions document


    	glutSwapBuffers();
    	stop = omp_get_wtime(); //// Record Stop time
    	printf("Time Taken: %f\n", stop - start); // Print Time Taken
}

/*//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
////%%% Keyboard Function: Define Key to rotate the Spheres/Planets %%%%%%%%%
////%%% f - Revolve and Rotate Planet's Moon 2 steps anti-clockwise %%%%%%%%%%% 
////%%% b - Revolve and Rotate Planet's Moon 2 steps clockwise %%%%%%%%%%%%%%%%
////%%% r - Reset Planet's Moon position and stop rotating %%%%%%%%%%%%%%%%%%%%
*///%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void keyboard (unsigned char key, int x, int y)
{
   switch (key) {
      case 'f':
         planet_pos = (planet_pos + 2) % 360;
         glutPostRedisplay();
         break;
      case 'b':
         planet_pos = (planet_pos - 2) % 360;
         glutPostRedisplay();
         break;
      case 'r':
         planet_pos = 0;
         glutPostRedisplay();
         break;
      default:
         break;
   }
}

void advanceDisplay(void)
{
	planet_pos = (planet_pos + 2) % 360;
	glutPostRedisplay();
}

void backDisplay(void)
{
	planet_pos = (planet_pos - 2) % 360;
	glutPostRedisplay();
}

void resetDisplay(void)
{
    planet_pos = 0;
    glutPostRedisplay();
}

/*//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
////%%% Mouse Function: Define Mouse Clicks to rotate the Spheres %%%%%%%%%%%%%%%%%%%%%
////%%% Left Button Click - Revolve and Rotate Planet Moon 2 steps anti-clockwise %%%%%%%%%%%%%
////%%% Right Button Click - Revolve and Rotate Planet Moon 2 steps clockwise %%%%%%%%%%%%%%%%%
////%%% Center Button Click - Reset Planet Moon position and stop rotating %%%%%%%%%%%%%%%%%%%%
*///%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void mouse(int button, int state, int x, int y)
{
    switch (button)
    {
    case GLUT_LEFT_BUTTON:
        if(state == GLUT_DOWN)
        {
            glutIdleFunc(advanceDisplay);
        }
        break;

    case GLUT_MIDDLE_BUTTON:
        if(state == GLUT_DOWN)
        {
            glutIdleFunc(resetDisplay);
        }
        break;

    case GLUT_RIGHT_BUTTON:
        if(state == GLUT_DOWN)
        {
            glutIdleFunc(backDisplay);
        }
        break;
    }
}
 
/* The Main Program */
 
int main(int argc, char *argv[])
{
    	glutInit(&argc, argv); // Initialize OpenGL Glut
    	glutInitWindowSize(900,600); //Display Size
    	glutInitWindowPosition(10,10); // Position on the Screen
    	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH); //Display Mode
 
    	glutCreateWindow("EEE4084F Prac3 - MPI with OpenGL Processing"); // Create a Window with Title
 
    	glutReshapeFunc(resize); //Resize Function
    	glutDisplayFunc(display); // Create the main Display (Rendering)
    	glutKeyboardFunc(keyboard); // Install Keyboard Function
    	glutMouseFunc(mouse); // Install Mouse Function

    	//Enable Lights - Makes Spheres look cleare and more 3-D
    	glEnable(GL_CULL_FACE);
    	glCullFace(GL_BACK);
 
    	glEnable(GL_DEPTH_TEST);
    	glDepthFunc(GL_LESS);
 
    	glEnable(GL_LIGHT0);
    	glEnable(GL_NORMALIZE);
    	glEnable(GL_COLOR_MATERIAL);
    	glEnable(GL_LIGHTING);
 
    	glLightfv(GL_LIGHT0, GL_AMBIENT,  light_ambient);
    	glLightfv(GL_LIGHT0, GL_DIFFUSE,  light_diffuse);
    	glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
    	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
 
    	glMaterialfv(GL_FRONT, GL_AMBIENT,   mat_ambient);
    	glMaterialfv(GL_FRONT, GL_DIFFUSE,   mat_diffuse);
    	glMaterialfv(GL_FRONT, GL_SPECULAR,  mat_specular);
    	glMaterialfv(GL_FRONT, GL_SHININESS, high_shininess);
        //Lights Enabling ends here. Read More to find out how it works.
 
    	glutMainLoop(); // End the main OpenGL Loop

    	return EXIT_SUCCESS;
}
